package com.jsrsys.web;

/******************************************************************************
// JsrUtil.java:   padLeft, padRight, string or integer input.
//                 output is padded or truncated as necessary.
 * Sample Use:
 * import JsrUtil;                  ... 
 * JsrUtil u = new JsrUtil();
 * paddedString  = u.padLeft(oldString,10);  // pad left with blanks
 * paddedString  = u.padLeft(oldInt,10);     // comma inserted every 3 bytes.
 * paddedString  = u.padLeft(oldInt,10,2);   //   " + .00 (2 is # decimal points).
 // 2000-01-11 add support for long integers for above two methods.

 * zeroPadInt    = u.padZero(oldInt,10);     // pad left with zeroes.
 * paddedString  = u.padRight(oldString,10); // pad right with blanks. 
 * dateTime      = u.getDateTime();
 * modString     = u.replaceAll(inString,fromString,toString);
 * fileRename    = u.renameFile(oldFileName,newFileName);
 * fileDelete    = u.deleteFile(fileName);
 * int           = u.getInt(inString); // makes String an int.
 *                 if not an Integer, returns Integer.MIN_VALUE
 * passString    = u.getRandom(lenOfPassString); // returns random string of len...
 * 
*/
import java.util.*;
import java.io.*;
/**
  * Various utility functions. padLeft/Right,DateTime,replace,rename,delete,getInt.
  */
public class JsrUtil
{ 
  static final String COPYRIGHT = 
  "Copyright 1998-2001, JSR Systems.  See: www.Jsrsys.com/copyright.";
  static final char[] blank = {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
                               ' ',' ',' ',' ',' ',' ',' ',' ',' ',' '};
                               // fifty (50) blanks for append...
  Random random;  
                               
  //JsrSysout sysout = new JsrSysout();  // To Do -- fix JsrSysout calling JsrUtil...
                               
                               
  public JsrUtil()  // null constructor
  {

  }

  static void main(String[] parm)
  {
    JsrUtil u = new JsrUtil();
    u.test();
    return;    
  }
  void test()
  {
    getRandom(4);
    getRandom(4);
    getRandom(4);
    getRandom(4);
    return;
  }

/**
  *return Random byte string
  */
  public String getRandom(int parmLen)   
  {

      byte[] b = new byte[parmLen];
      char[] c = new char[parmLen];
      int bx   = 0;
      if (random == null) random = new Random();
      random.nextBytes(b);
      for (int i = 0; i < parmLen; i++)
      {
         bx = b[i];
         if (bx <   0) bx = - bx;
         if (bx > 255) bx -= 255;
         if (bx > 122) bx -= 122;         // GT z 
         if (bx <  48) bx +=  48;         // LT 0
         if (bx > 57 && bx < 65) bx -= 9; // :;<=>?@
         if (bx > 90 && bx < 97) bx += 9; // [\]^_'
         c[i] = (char)bx;
      }
      //System.out.print("c/b/bx=");
      //for (int i = 0; i < parmLen; i++) System.out.print(c[i] +"/"+  b[i] +"/"+  bx +" ");
      String s = new String(c);
      //System.out.println("s=" + s);
      return s;
  }

/**
  *pad left with blanks
  */
  public String padLeft(String parmString, int parmLen)   
  {
     String       tempString;
     int          addLen;
     StringBuffer sb = new StringBuffer(parmLen);
     // set capacity of initial buffer to desired length!
     if (parmString.length()    > parmLen)
        tempString = parmString.substring(parmString.length()-parmLen,
                                          parmString.length());
     else
     {
        // tempString = parmString;
        // while (tempString.length() < parmLen)
        //   tempString = " "+tempString;
        addLen = parmLen - parmString.length();
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks w/ original string on end
        tempString = sb.append(blank,0,addLen).append(parmString).toString();
     }
     return tempString;  
  }
  
/**
  *comma inserted every 3 bytes.
  */
  public String padLeft(int parmInt, int parmLen)   
  {
     Integer tempInt    = new Integer(parmInt);
     String  tempString = tempInt.toString();
     int digitLen = tempString.length();
     int numComma = (digitLen-1) / 3;
     int addLen   = parmLen - digitLen - numComma;
     StringBuffer sb = new StringBuffer(parmLen);
     if (addLen > 0)
     {
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks w/ original string on end
        sb.append(blank,0,addLen).append(tempString); 
      }
      else sb.append(tempString);
      
     // System.out.println("d/n/a:"+digitLen+"/"+numComma+"/"+addLen+sb); 
     int commaPos = sb.length() - 3;
     while (numComma > 0)
     {
        sb.insert(commaPos,',');
        commaPos -= 3;
        numComma--;
     }
     // 2000-06-25 for integer input -only- put in ",".
     //            also, do not truncate if longer than parmLen!
     // return padLeft(tempString, parmLen);
     return sb.toString();
  } 

/**
  *comma inserted every 3 bytes + .00 (2 is # decimal points).
  */
  public String padLeft(int parmInt, int parmLen, int parmDecimal)   
  {
     Integer tempInt    = new Integer(parmInt);
     String  tempString = tempInt.toString();
     while (tempString.length() < parmDecimal) tempString = "0"+tempString;
           // make sure there are parmDecimal zeroes.
     int digitLen = tempString.length();
     int numComma = (digitLen - 1 - parmDecimal) / 3;
     int addLen   = parmLen - digitLen - numComma - 1;
     StringBuffer sb = new StringBuffer(parmLen);
     if (addLen > 0)
     {
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks w/ original string on end
        sb.append(blank,0,addLen).append(tempString); 
      }
      else sb.append(tempString);
      
     // System.out.println("d/n/a:"+digitLen+"/"+numComma+"/"+addLen+sb);
     int decimalPos = sb.length() - parmDecimal;
     sb.insert(decimalPos,'.');
     
     int commaPos = sb.length() - 4 - parmDecimal;
     while (numComma > 0)
     {
        sb.insert(commaPos,',');
        commaPos -= 3;
        numComma--;
     }
     // 2000-11-27 added parmDecimal method...
     // 2000-06-25 for integer input -only- put in ",".
     //            also, do not truncate if longer than parmLen!
     // return padLeft(tempString, parmLen);
     return sb.toString();
  }
  

  // 2000-01-11 add support for long integers

/**
  *comma inserted every 3 bytes.
  */
  public String padLeft(long parmInt, int parmLen)   
  {
     Long tempInt    = new Long(parmInt);
     String  tempString = tempInt.toString();
     int digitLen = tempString.length();
     int numComma = (digitLen-1) / 3;
     int addLen   = parmLen - digitLen - numComma;
     StringBuffer sb = new StringBuffer(parmLen);
     if (addLen > 0)
     {
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks w/ original string on end
        sb.append(blank,0,addLen).append(tempString); 
      }
      else sb.append(tempString);
      
     // System.out.println("d/n/a:"+digitLen+"/"+numComma+"/"+addLen+sb); 
     int commaPos = sb.length() - 3;
     while (numComma > 0)
     {
        sb.insert(commaPos,',');
        commaPos -= 3;
        numComma--;
     }
     return sb.toString();
  } 

/**
  *comma inserted every 3 bytes + .00 (2 is # decimal points).
  */
  public String padLeft(long parmInt, int parmLen, int parmDecimal)   
  {
     Long tempInt    = new Long(parmInt);
     String  tempString = tempInt.toString();
     while (tempString.length() < parmDecimal) tempString = "0"+tempString;
           // make sure there are parmDecimal zeroes.
     int digitLen = tempString.length();
     int numComma = (digitLen - 1 - parmDecimal) / 3;
     int addLen   = parmLen - digitLen - numComma - 1;
     StringBuffer sb = new StringBuffer(parmLen);
     if (addLen > 0)
     {
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks w/ original string on end
        sb.append(blank,0,addLen).append(tempString); 
      }
      else sb.append(tempString);
      
     // System.out.println("d/n/a:"+digitLen+"/"+numComma+"/"+addLen+sb);
     int decimalPos = sb.length() - parmDecimal;
     sb.insert(decimalPos,'.');
     
     int commaPos = sb.length() - 4 - parmDecimal;
     while (numComma > 0)
     {
        sb.insert(commaPos,',');
        commaPos -= 3;
        numComma--;
     }
     return sb.toString();
  } 
  // 2000-01-11 add support for long integers

/**
  * pad left with zeroes.
  */
  public String padZero(int parmInt, int parmLen)   
  {
     Integer tempInt    = new Integer(parmInt);
     String  tempString = tempInt.toString();
     if (tempString.length()    > parmLen)
        tempString = tempString.substring(tempString.length()-parmLen,
                                          tempString.length());
     else
     {
        while (tempString.length() < parmLen)
          tempString = "0"+tempString;
     }
     return tempString;  
  } 

/**
  * pad right with blanks
  */
  public String padRight(String parmString, int parmLen)   
  {
     String       tempString;
     int          addLen;
     StringBuffer sb = new StringBuffer(parmLen);
     // set capacity of initial buffer to desired length!
     if (parmString.length()    > parmLen)
        tempString = parmString.substring(0,parmLen+1);
     else
     {
        //tempString = parmString;
        //while (tempString.length() < parmLen)
        //  tempString = tempString + " ";
        // 2000-06-24 replace above with following more efficient code
        // above code actualy generates:
        //  tempString = new StringBuffer().append(tempString).append(" ").toString();
        //  (i.e., a new StringBuffer is allocated, data is put into it,
        //         it is converted back to a string, for EACH character added)
        addLen = parmLen - parmString.length();
        sb = sb.append(parmString);
        while (addLen > 50) // char[] array is only 50 blanks.
        {
          sb = sb.append(blank,0,50);
          addLen -= 50;
        } // now append final set of blanks 
        tempString = sb.append(blank,0,addLen).toString();
     }
     return tempString;  
  } 

/**
  *  get todays date/time yyyy-mm-dd hh:mm (ISO standard format).
  */
  public String getDateTime()   
  {
      Calendar rightNow = Calendar.getInstance();
      String   today = rightNow.get(Calendar.YEAR)+"-"+
               padZero(rightNow.get(Calendar.MONTH)+1,2)+"-"+
               padZero(rightNow.get(Calendar.DAY_OF_MONTH),2)+" "+
               padZero(rightNow.get(Calendar.HOUR_OF_DAY),2)+":"+
               padZero(rightNow.get(Calendar.MINUTE),2);
       // add 1 to month because Calendar returns 0 for January!!!
     return today;
  }
  
/**
  *  get todays date/time yyyy-mm-dd hh:mm:ss (ISO standard format, w/ seconds).
  */
  public String getDateTimeAll()   
  {
      Calendar rightNow = Calendar.getInstance();
      String   today = rightNow.get(Calendar.YEAR)+"-"+
               padZero(rightNow.get(Calendar.MONTH)+1,2)+"-"+
               padZero(rightNow.get(Calendar.DAY_OF_MONTH),2)+" "+
               padZero(rightNow.get(Calendar.HOUR_OF_DAY),2)+":"+
               padZero(rightNow.get(Calendar.MINUTE),2)+":"+
               padZero(rightNow.get(Calendar.SECOND),2);
       // add 1 to month because Calendar returns 0 for January!!!
     return today;
  }
  
/**
  * modifies all occurences of "from" to "to". <BR>
  * &nbsp; &nbsp; &nbsp; &nbsp; special cases:<BR>
  * &nbsp; &nbsp; &nbsp; &nbsp; toString = '*delete*', newString='*delete* if find fromString<BR>
  * &nbsp; &nbsp; &nbsp; &nbsp; fromString ends in '=', replace text following '='
  *                        to first space, '>' or end-of-line.<BR>
  * &nbsp; &nbsp; &nbsp; &nbsp; example from: 'WIDTH=' to: ''<BR>
  * &nbsp; &nbsp; &nbsp; &nbsp; --------- old: 'xxWIDTH=abc z'  becomes: 'xxz'<BR>
  */
  public String replaceAll(String oldString, String from, String to)
  {
    int lenFrom = from.length();
    int lenTo   =   to.length();
    String newSB = new String();
    char endFrom = from.charAt(lenFrom-1);
    char numChar = ' ';
    int where = 0;
    int last  = 0;
    int lenOld = oldString.length();
    where = oldString.indexOf(from);
    if (to.equals("*delete*") && where != -1)
       newSB = "*delete*";
    else
    {
     while (where != -1)
     {
       newSB = newSB+oldString.substring(last,where)+to;
       last  = where + lenFrom;
       if (endFrom == '=')
       {
          numChar = oldString.charAt(last);  
          while (numChar > ' ' && numChar != '>' && last < lenOld)
                 //  skip to next white space or '>' or end of line 
          {
            last++;
            numChar = oldString.charAt(last);  
            //System.out.println("numChar="+numChar);
          }
       }          
       where = oldString.indexOf(from,last);
     } 
     newSB = newSB+oldString.substring(last,lenOld);
    }
    return newSB;
  }
  //  end of replaceAll
/**
  * rename a file.
  */
  public void renameFile(String oldFileName, String newFileName)
  {
    File  oldFD = new File(oldFileName);
    File  newFD = new File(newFileName);
    if (newFD.exists() == true) 
        //sysout.display
        System.out.println("delete "          + newFD+"=" + newFD.delete());
    //sysout.display
    System.out.println("rename "+oldFD+ " to "+ newFD+"=" + oldFD.renameTo(newFD));
  

  }
  // end of renameFile

/**
  * delete a file.
  */
  public void deleteFile(String fileName) 
  {
    File delFD = new File(fileName);
    if  (delFD.exists() == true)
         //sysout.display
         System.out.println("delete "          + delFD+"=" + delFD.delete());
    else
         //sysout.display
         System.out.println("File: "+ fileName+ " does not exist.");
  }
  // end of deleteFile
  
/**
  * getInt(String) -- so don't have to remember how to do it.
  */
  public int getInt( String parmNumber)   
  {
     //Integer tempInt    = new Integer(parmNumber);
     //return tempInt.intValue(); // old way.
    try
    { return Integer.parseInt(parmNumber);}
    catch (NumberFormatException e)
    {     return Integer.MIN_VALUE;       }
  }
  // end of getInt

} 
